// $Id: CMidiEventList.cpp,v 1.6 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMidiEventList.hpp"
using Exponent::Midi::CMidiEventList;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiEventList, CCountedObject);

//	===========================================================================
CMidiEventList::CMidiEventList() : m_midiChannel(0), m_numberOfEvents(0), m_currentEvent(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiEventList);
}

//	===========================================================================
CMidiEventList::~CMidiEventList()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiEventList);
}

//	===========================================================================
const CMidiEvent *CMidiEventList::getNextEvent() const
{
	if (m_currentEvent == -1)
	{
		return NULL;
	}
	return &m_list[m_currentEvent];
}

//	===========================================================================
void CMidiEventList::moveToNextEvent()
{
	// Increment
	m_currentEvent++;

	// Check its within range
	if (m_currentEvent >= m_numberOfEvents)
	{
		m_currentEvent = 0;
	}
}

//	===========================================================================
bool CMidiEventList::moreEvents() const
{
	return (m_currentEvent + 1 < m_numberOfEvents);
}

//	===========================================================================
long CMidiEventList::getTimeDeltaDifference() const
{
	if (m_numberOfEvents == 0)
	{
		return 0;
	}
	else if (m_currentEvent == -1)
	{
		return 0;
	}
	else if (m_currentEvent + 1 >= m_numberOfEvents)
	{
		return 0;
	}

	return m_list[m_currentEvent + 1].getTimeDelta() - m_list[m_currentEvent].getTimeDelta();
}

//	===========================================================================
const CMidiEvent *CMidiEventList::getEventAtIndex(const long index) const
{
	if (index >= 0 && index < m_numberOfEvents)
	{
		return &m_list[index];
	}
	return NULL;
}

//	===========================================================================
void CMidiEventList::clearEvents()
{
	m_currentEvent   = 0;
	m_numberOfEvents = 0;
}

//	===========================================================================
void CMidiEventList::getObjectDescription(char *string, const long size) const
{
	CString description;
	description.setStringWithFormat("[Number Of Events(%li), Channel(%li)]", m_numberOfEvents, m_midiChannel);
	description.getString(string, size);
}